/*- Stepper full -
 * This example demonstrates the basic usage of a Phidget Stepper controller.  It demonstrates the manipulation 
 * of the velocity, goal position and acceleration of the stepper, as well as displays the data from generated 
 * events including current position.  If the connected Phidget STepper is Bipolar, the user will be shown 
 * Current values as well as being able to manipulate stepper torque.
 *
 * Please note that this example was designed to work with only one Phidget Stepper connected.
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package Stepper;

import com.phidgets.StepperPhidget;
import com.phidgets.PhidgetException;

import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

import listeners.*;

public class Stepper extends javax.swing.JFrame {
    
    private static String runArgs[];
    private StepperPhidget stepper;
    private StepperAttachListener attach_listener;
    private StepperDetachListener detach_listener;
    private StepperErrorListener error_listener;
    private StepperCurrentChangeListener current_listener;
    private StepperInputChangeListener input_listener;
    private StepperPositionListener position_listener;
    private StepperVelocityListener velocity_listener;
    private JCheckBox inputArray[];
    
    /** Creates new form Stepper */
    public Stepper() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel2 = new javax.swing.JPanel();
        jLabel6 = new javax.swing.JLabel();
        motorCmb = new javax.swing.JComboBox();
        jLabel7 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        velActualTxt = new javax.swing.JTextField();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        posTargetTxt = new javax.swing.JTextField();
        accelTxt = new javax.swing.JTextField();
        velLimitTxt = new javax.swing.JTextField();
        jLabel12 = new javax.swing.JLabel();
        currentLimitTxt = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        jLabel18 = new javax.swing.JLabel();
        posActualTxt = new javax.swing.JTextField();
        currentActualTxt = new javax.swing.JTextField();
        engagedChk = new javax.swing.JCheckBox();
        stoppedChk = new javax.swing.JCheckBox();
        jLabel13 = new javax.swing.JLabel();
        velLimitScrl = new javax.swing.JSlider();
        jLabel14 = new javax.swing.JLabel();
        accelScrl = new javax.swing.JSlider();
        jLabel15 = new javax.swing.JLabel();
        targetPosScrl = new javax.swing.JSlider();
        jLabel10 = new javax.swing.JLabel();
        currentPosScrl = new javax.swing.JSlider();
        jLabel11 = new javax.swing.JLabel();
        currentLimitScrl = new javax.swing.JSlider();
        jPanel1 = new javax.swing.JPanel();
        attachedTxt = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jScrollPane1 = new javax.swing.JScrollPane();
        nameTxt = new javax.swing.JTextArea();
        jLabel2 = new javax.swing.JLabel();
        serialTxt = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        versionTxt = new javax.swing.JTextField();
        jLabel4 = new javax.swing.JLabel();
        numMotorsTxt = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        in0Chk = new javax.swing.JCheckBox();
        in1Chk = new javax.swing.JCheckBox();
        in2Chk = new javax.swing.JCheckBox();
        in3Chk = new javax.swing.JCheckBox();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Stepper - full");
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosed(java.awt.event.WindowEvent evt) {
                formWindowClosed(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Motor Data"));

        jLabel6.setText("Choose Stepper Motor:");

        motorCmb.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                motorCmbActionPerformed(evt);
            }
        });

        jLabel7.setText("Velocity Limit:");

        jLabel16.setText("Actual:");

        velActualTxt.setEditable(false);

        jLabel8.setText("Acceleration:");

        jLabel9.setText("Position Target:");

        posTargetTxt.setEditable(false);

        accelTxt.setEditable(false);

        velLimitTxt.setEditable(false);

        jLabel12.setText("Current Limit:");

        currentLimitTxt.setEditable(false);

        jLabel17.setText("Actual:");

        jLabel18.setText("Actual:");

        posActualTxt.setEditable(false);

        currentActualTxt.setEditable(false);

        engagedChk.setText("Engaged");
        engagedChk.setEnabled(false);
        engagedChk.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                engagedChkStateChanged(evt);
            }
        });

        stoppedChk.setSelected(true);
        stoppedChk.setText("Stopped");
        stoppedChk.setEnabled(false);

        jLabel13.setText("Velocity Limit:");

        velLimitScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                velLimitScrlStateChanged(evt);
            }
        });

        jLabel14.setText("Acceleration:");

        accelScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                accelScrlStateChanged(evt);
            }
        });

        jLabel15.setText("Target Position:");

        targetPosScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                targetPosScrlStateChanged(evt);
            }
        });

        jLabel10.setText("Current Position:");

        currentPosScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                currentPosScrlStateChanged(evt);
            }
        });

        jLabel11.setText("Current Limit:");

        currentLimitScrl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                currentLimitScrlStateChanged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(60, 60, 60)
                        .add(jLabel6)
                        .add(6, 6, 6)
                        .add(motorCmb, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 91, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel9)
                            .add(jLabel8)
                            .add(jLabel7)
                            .add(jLabel12))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(velLimitTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                                .add(jLabel16)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(velActualTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(accelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(posTargetTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                                .add(jLabel17)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(posActualTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(currentLimitTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                                .add(10, 10, 10)
                                .add(jLabel18)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(currentActualTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 100, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jPanel2Layout.createSequentialGroup()
                                .add(11, 11, 11)
                                .add(engagedChk)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(stoppedChk)))
                        .add(10, 10, 10))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel13))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(velLimitScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 338, Short.MAX_VALUE))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel14))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(accelScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 338, Short.MAX_VALUE))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel15))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(targetPosScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 338, Short.MAX_VALUE))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel10))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(currentPosScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 338, Short.MAX_VALUE))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jLabel11))
                    .add(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(currentLimitScrl, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 338, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6)
                    .add(motorCmb, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(18, 18, 18)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(velLimitTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel7)
                    .add(jLabel16)
                    .add(velActualTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(accelTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel8))
                .add(8, 8, 8)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel9)
                    .add(posTargetTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel17)
                    .add(posActualTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(currentLimitTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel12)
                    .add(currentActualTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel18))
                .add(18, 18, 18)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(engagedChk)
                    .add(stoppedChk))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(jLabel13)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(velLimitScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel14)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(accelScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel15)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(targetPosScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel10)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(currentPosScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel11)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(currentLimitScrl, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Stepper Info"));

        attachedTxt.setEditable(false);

        jLabel1.setText("Attached:");

        nameTxt.setBackground(javax.swing.UIManager.getDefaults().getColor("TextField.disabledBackground"));
        nameTxt.setColumns(20);
        nameTxt.setEditable(false);
        nameTxt.setLineWrap(true);
        nameTxt.setRows(3);
        nameTxt.setTabSize(2);
        nameTxt.setWrapStyleWord(true);
        jScrollPane1.setViewportView(nameTxt);

        jLabel2.setText("Name:");

        serialTxt.setEditable(false);

        jLabel3.setText("Serial No.:");

        versionTxt.setEditable(false);

        jLabel4.setText("Version:");

        numMotorsTxt.setEditable(false);

        jLabel5.setText("# Steppers:");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .add(35, 35, 35)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabel1)
                    .add(jLabel2)
                    .add(jLabel4)
                    .add(jLabel3)
                    .add(jLabel5))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, numMotorsTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, versionTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, serialTxt)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jScrollPane1)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, attachedTxt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 215, Short.MAX_VALUE))
                .addContainerGap(46, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel1)
                    .add(attachedTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(15, 15, 15)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel2))
                .add(16, 16, 16)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(serialTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel3))
                .add(16, 16, 16)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(versionTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel4))
                .add(15, 15, 15)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(numMotorsTxt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel5))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder("Input Data"));
        jPanel3.setMaximumSize(new java.awt.Dimension(249, 51));

        in0Chk.setText("Input 0");
        in0Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in0Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in1Chk.setText("Input 1");
        in1Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in1Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in2Chk.setText("Input 2");
        in2Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in2Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        in3Chk.setText("Input 3");
        in3Chk.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        in3Chk.setMargin(new java.awt.Insets(0, 0, 0, 0));

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(53, 53, 53)
                .add(in0Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in1Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in2Chk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(in3Chk)
                .addContainerGap(75, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(in0Chk)
                    .add(in1Chk)
                    .add(in2Chk)
                    .add(in3Chk))
                .addContainerGap(23, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING, false)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel3, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    /**
     * initialize the stepper object and hook the event listeners
     **/
    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        inputArray = new JCheckBox[4];
        
        inputArray[0] = in0Chk;
        inputArray[1] = in1Chk;
        inputArray[2] = in2Chk;
        inputArray[3] = in3Chk;
        
        for(int i = 0; i < 4; i++)
        {
            inputArray[i].setVisible(false);
            inputArray[i].setEnabled(false);
        }
        
        motorCmb.setEnabled(false);
        velLimitScrl.setEnabled(false);
        accelScrl.setEnabled(false);
        targetPosScrl.setEnabled(false);
        currentPosScrl.setEnabled(false);
        
        jLabel12.setVisible(false);
        currentLimitTxt.setVisible(false);
        jLabel18.setVisible(false);
        currentActualTxt.setVisible(false);
        
        jLabel11.setVisible(false);
        currentLimitScrl.setVisible(false);
        currentLimitScrl.setEnabled(false);
        
        try
        {
            stepper = new StepperPhidget();
            
            attach_listener = new StepperAttachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt,
                    this.numMotorsTxt, this.motorCmb, this.velLimitTxt,
                    this.velActualTxt, this.accelTxt, this.posTargetTxt,
                    this.posActualTxt, this.currentLimitTxt, this.currentActualTxt,
                    this.velLimitScrl, this.accelScrl, this.targetPosScrl,
                    this.currentPosScrl, this.currentLimitScrl, this.inputArray,
                    this.jLabel11, this.jLabel12, this.jLabel18, this.engagedChk,
                    this.stoppedChk);
            
            detach_listener = new StepperDetachListener(this, this.attachedTxt,
                    this.nameTxt, this.serialTxt, this.versionTxt,
                    this.numMotorsTxt, this.motorCmb, this.velLimitTxt,
                    this.velActualTxt, this.accelTxt, this.posTargetTxt,
                    this.posActualTxt, this.currentLimitTxt, this.currentActualTxt,
                    this.velLimitScrl, this.accelScrl, this.targetPosScrl,
                    this.currentPosScrl, this.currentLimitScrl, this.inputArray,
                    this.jLabel11, this.jLabel12, this.jLabel18, this.engagedChk,
                    this.stoppedChk);
            
            error_listener = new StepperErrorListener(this);
            
            current_listener = new StepperCurrentChangeListener(this.motorCmb, this.currentLimitTxt);
            
            input_listener = new StepperInputChangeListener(this.inputArray);
            
            position_listener = new StepperPositionListener(this, this.motorCmb, this.posActualTxt, this.stoppedChk, this.currentPosScrl);
            
            velocity_listener = new StepperVelocityListener(this, this.motorCmb, this.velActualTxt, this.stoppedChk, this.currentPosScrl);
            
            stepper.addAttachListener(attach_listener);
            stepper.addDetachListener(detach_listener);
            stepper.addErrorListener(error_listener);
            stepper.addCurrentChangeListener(current_listener);
            stepper.addInputChangeListener(input_listener);
            stepper.addStepperPositionChangeListener(position_listener);
            stepper.addStepperVelocityChangeListener(velocity_listener);
            
            //This assumes that if there is a command line argument, it is a serial number
            //and we try to open that specific device. Otherwise, open any device.
            if((runArgs.length > 1) && (runArgs[1].equals("remote")))
            {
                stepper.open(Integer.parseInt(runArgs[0]), null);
            }
            else if(runArgs.length > 0)
            {
                stepper.open(Integer.parseInt(runArgs[0]));
            }
            else
            {
                stepper.openAny();
            }
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
        }
    }//GEN-LAST:event_formWindowOpened

    private void motorCmbActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_motorCmbActionPerformed
        if(motorCmb.isEnabled())
        {
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    targetPosScrl.setValueIsAdjusting(true);
                    targetPosScrl.setValue((int)stepper.getTargetPosition(((Integer)motorCmb.getSelectedItem()).intValue()));
                    targetPosScrl.setValueIsAdjusting(false);
                    posTargetTxt.setText(Long.toString(stepper.getTargetPosition(((Integer)motorCmb.getSelectedItem()).intValue())));
                }
            }
            catch(PhidgetException ex)
            {
                targetPosScrl.setValueIsAdjusting(true);
                targetPosScrl.setValue(0);
                targetPosScrl.setValueIsAdjusting(false);
                posTargetTxt.setText("");
            }
            
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    currentPosScrl.setValueIsAdjusting(true);
                    currentPosScrl.setValue((int)stepper.getCurrentPosition(((Integer)motorCmb.getSelectedItem()).intValue()));
                    currentPosScrl.setValueIsAdjusting(false);
                    posActualTxt.setText(Long.toString(stepper.getCurrentPosition(((Integer)motorCmb.getSelectedItem()).intValue())));
                }
            }
            catch(PhidgetException ex)
            {
                currentPosScrl.setValueIsAdjusting(true);
                currentPosScrl.setValue(0);
                currentPosScrl.setValueIsAdjusting(false);
                posActualTxt.setText("");
            }
            
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    velLimitScrl.setValueIsAdjusting(true);
                    velLimitScrl.setValue((int)stepper.getVelocityLimit(((Integer)motorCmb.getSelectedItem()).intValue()));
                    velLimitScrl.setValueIsAdjusting(false);
                    velLimitTxt.setText(Double.toString(stepper.getVelocityLimit(((Integer)motorCmb.getSelectedItem()).intValue())));
                }
            }
            catch(PhidgetException ex)
            {
                velLimitScrl.setValueIsAdjusting(true);
                velLimitScrl.setValue(velLimitScrl.getMinimum());
                velLimitScrl.setValueIsAdjusting(false);
                velLimitTxt.setText("");
            }
            
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    accelTxt.setText(Double.toString(stepper.getAcceleration(((Integer)motorCmb.getSelectedItem()).intValue())));
                    accelScrl.setValueIsAdjusting(true);
                    accelScrl.setValue((int)stepper.getAcceleration(((Integer)motorCmb.getSelectedItem()).intValue()));
                    accelScrl.setValueIsAdjusting(false);
                }
            }
            catch(PhidgetException ex)
            {
                accelScrl.setValueIsAdjusting(true);
                accelScrl.setValue(accelScrl.getMinimum());
                accelScrl.setValueIsAdjusting(false);
                accelTxt.setText("");
            }
            
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                    velActualTxt.setText(Double.toString(stepper.getVelocity(((Integer)motorCmb.getSelectedItem()).intValue())));
            }
            catch(PhidgetException ex)
            {
                velActualTxt.setText("");
            }
            
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                    currentActualTxt.setText(Double.toString(stepper.getCurrent(((Integer)motorCmb.getSelectedItem()).intValue())));
            }
            catch(PhidgetException ex)
            {
                currentActualTxt.setText("");
            }
            
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    stoppedChk.setSelected(stepper.getStopped(((Integer)motorCmb.getSelectedItem()).intValue()));
                    currentPosScrl.setEnabled(stepper.getStopped(((Integer)motorCmb.getSelectedItem()).intValue()));
                }
            }
            catch(PhidgetException ex)
            {
                stoppedChk.setSelected(false);
                currentPosScrl.setEnabled(false);
            }
            
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                    engagedChk.setSelected(stepper.getEngaged(((Integer)motorCmb.getSelectedItem()).intValue()));
            }
            catch(PhidgetException ex)
            {
                engagedChk.setSelected(false);
            }
            
            currentLimitTxt.setText("");
            currentLimitScrl.setValueIsAdjusting(true);
            currentLimitScrl.setValue(currentLimitScrl.getMinimum());
            currentLimitScrl.setValueIsAdjusting(false);
        }
    }//GEN-LAST:event_motorCmbActionPerformed

    private void velLimitScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_velLimitScrlStateChanged
        if(velLimitScrl.isEnabled())
        {
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    double vel = velLimitScrl.getValue();

                    if(vel < stepper.getVelocityMin(((Integer)motorCmb.getSelectedItem()).intValue()))
                        vel = stepper.getVelocityMin(((Integer)motorCmb.getSelectedItem()).intValue());
                    if(vel > stepper.getVelocityMax(((Integer)motorCmb.getSelectedItem()).intValue()))
                        vel = stepper.getVelocityMax(((Integer)motorCmb.getSelectedItem()).intValue());

                    stepper.setVelocityLimit(((Integer)motorCmb.getSelectedItem()).intValue(), vel);
                    velLimitTxt.setText(Double.toString(stepper.getVelocityLimit(((Integer)motorCmb.getSelectedItem()).intValue())));
                }
            }
            catch(PhidgetException ex)
            {
                velLimitTxt.setText("Err");
            }
        }
}//GEN-LAST:event_velLimitScrlStateChanged

    private void accelScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_accelScrlStateChanged
        if(accelScrl.isEnabled())
        {
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    double accel = accelScrl.getValue();
                    if(accel < stepper.getAccelerationMin(((Integer)motorCmb.getSelectedItem()).intValue()))
                        accel = stepper.getAccelerationMin(((Integer)motorCmb.getSelectedItem()).intValue());
                    if(accel > stepper.getAccelerationMax(((Integer)motorCmb.getSelectedItem()).intValue()))
                        accel = stepper.getAccelerationMax(((Integer)motorCmb.getSelectedItem()).intValue());

                    stepper.setAcceleration(((Integer)motorCmb.getSelectedItem()).intValue(), accel);
                    accelTxt.setText(Double.toString(stepper.getAcceleration(((Integer)motorCmb.getSelectedItem()).intValue())));
                }
            }
            catch(PhidgetException ex)
            {
                accelTxt.setText("Err");
            }
        }
    }//GEN-LAST:event_accelScrlStateChanged

    private void targetPosScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_targetPosScrlStateChanged
        if(targetPosScrl.isEnabled())
        {
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    stepper.setTargetPosition(((Integer)motorCmb.getSelectedItem()).intValue(), targetPosScrl.getValue());
                    posTargetTxt.setText(Long.toString(stepper.getTargetPosition(((Integer)motorCmb.getSelectedItem()).intValue())));
                }
            }
            catch(PhidgetException ex)
            {
                posTargetTxt.setText("Err");
            }
        }
    }//GEN-LAST:event_targetPosScrlStateChanged

    private void formWindowClosed(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosed
        try
        {
            stepper.removeAttachListener(attach_listener);
            stepper.removeDetachListener(detach_listener);
            stepper.removeErrorListener(error_listener);
            stepper.removeCurrentChangeListener(current_listener);
            stepper.removeInputChangeListener(input_listener);
            stepper.removeStepperPositionChangeListener(position_listener);
            stepper.removeStepperVelocityChangeListener(velocity_listener);
            
            if(stepper.isAttached())
            {
                for(int i = 0; i < stepper.getMotorCount(); i++)
                {
                    stepper.setEngaged(i, false);
                }
            }
            
            stepper.close();
            
            stepper = null;
            
            dispose();
            System.exit(0);
        }
        catch(PhidgetException ex)
        {
            JOptionPane.showMessageDialog(this, ex.getDescription(), "Phidget Error" + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            dispose();
            System.exit(0);
        }
    }//GEN-LAST:event_formWindowClosed

    private void engagedChkStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_engagedChkStateChanged
        if(engagedChk.isEnabled())
        {
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    stepper.setEngaged(((Integer)motorCmb.getSelectedItem()).intValue(), engagedChk.isSelected());
                }
            }
            catch(PhidgetException ex)
            {

            }
        }
    }//GEN-LAST:event_engagedChkStateChanged

    private void currentPosScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_currentPosScrlStateChanged
        if(currentPosScrl.isEnabled())
        {
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    stepper.setCurrentPosition(((Integer)motorCmb.getSelectedItem()).intValue(), currentPosScrl.getValue());
                    posTargetTxt.setText(Integer.toString(currentPosScrl.getValue()));
                }
            }
            catch(PhidgetException ex)
            {
                posTargetTxt.setText("Err");
            }
        }
    }//GEN-LAST:event_currentPosScrlStateChanged

    private void currentLimitScrlStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_currentLimitScrlStateChanged
        if(currentLimitScrl.isEnabled())
        {
            try
            {
                if(stepper.isAttached() || stepper.isAttachedToServer())
                {
                    double current = currentLimitScrl.getValue() /100.0;
                    if(current < stepper.getCurrentMin(((Integer)motorCmb.getSelectedItem()).intValue()))
                        current = stepper.getCurrentMin(((Integer)motorCmb.getSelectedItem()).intValue());
                    if(current > stepper.getCurrentMax(((Integer)motorCmb.getSelectedItem()).intValue()))
                        current = stepper.getCurrentMax(((Integer)motorCmb.getSelectedItem()).intValue());

                    stepper.setCurrentLimit(((Integer)motorCmb.getSelectedItem()).intValue(), current);
                    currentLimitTxt.setText(Double.toString(stepper.getCurrentLimit(((Integer)motorCmb.getSelectedItem()).intValue())));
                }
            }
            catch(PhidgetException ex)
            {
                currentLimitTxt.setText("Err");
            }
        }
    }//GEN-LAST:event_currentLimitScrlStateChanged
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        runArgs = args;
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new Stepper().setVisible(true);
            }
        });
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSlider accelScrl;
    private javax.swing.JTextField accelTxt;
    private javax.swing.JTextField attachedTxt;
    private javax.swing.JTextField currentActualTxt;
    private javax.swing.JSlider currentLimitScrl;
    private javax.swing.JTextField currentLimitTxt;
    private javax.swing.JSlider currentPosScrl;
    private javax.swing.JCheckBox engagedChk;
    private javax.swing.JCheckBox in0Chk;
    private javax.swing.JCheckBox in1Chk;
    private javax.swing.JCheckBox in2Chk;
    private javax.swing.JCheckBox in3Chk;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JComboBox motorCmb;
    private javax.swing.JTextArea nameTxt;
    private javax.swing.JTextField numMotorsTxt;
    private javax.swing.JTextField posActualTxt;
    private javax.swing.JTextField posTargetTxt;
    private javax.swing.JTextField serialTxt;
    private javax.swing.JCheckBox stoppedChk;
    private javax.swing.JSlider targetPosScrl;
    private javax.swing.JTextField velActualTxt;
    private javax.swing.JSlider velLimitScrl;
    private javax.swing.JTextField velLimitTxt;
    private javax.swing.JTextField versionTxt;
    // End of variables declaration//GEN-END:variables
    
}
